if unsupported then return end

local function vertical_map()
    local pos = gLevels[gGlobalSyncTable.level].flagPos
    local dist = math.floor(dist_between_object_and_point(gMarioStates[0].marioObj, pos.x, pos.y, pos.z) / 100)
    local distText = tostring(dist)
    local size = 100
    local boundaries = 65535
    local theme = get_selected_theme()

    if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then return end
    if eHudVariables.minimap == false then return end
    if obj_get_first_with_behavior_id(id_bhvActSelector) ~= nil then return end

    djui_hud_set_resolution(RESOLUTION_N64)

    djui_hud_set_color(theme.minimap.r, theme.minimap.g, theme.minimap.b, theme.minimap.a)

    if eHudVariables.outlines then
        djui_hud_render_rect_rounded_outlined(djui_hud_get_screen_width() - 18.5, 72, 5, size, theme.minimapOutline.r, theme.minimapOutline.g, theme.minimapOutline.b, 1)
    else
        djui_hud_render_rect(djui_hud_get_screen_width() - 18.5, 72, 5, size)
    end

    for i = 0, MAX_PLAYERS -1 do
        local np = gNetworkPlayers[i]
        if np.connected and not gPlayerSyncTable[i].finished and gMarioStates[i].health > 0xff then
            render_player_head(i, djui_hud_get_screen_width() - 70 + (size/2) + (0), math.min(35 + (size / 2) + 80, 35 + (size/2) + (math.floor(dist_between_object_and_point(gMarioStates[i].marioObj, pos.x, pos.y, pos.z) / 100)/2)), 0.5, 0.5)
        end
    end
end

hook_event(HOOK_ON_HUD_RENDER, vertical_map)